/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.displayLink.source;

import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlock;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlockEntity;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import com.zurrtum.create.content.redstone.displayLink.source.AccumulatedItemCountDisplaySource;
import com.zurrtum.create.content.redstone.displayLink.target.DisplayTargetStats;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.class_2487;
import net.minecraft.class_2494;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_5250;

public class ItemThroughputDisplaySource
extends AccumulatedItemCountDisplaySource {
    private final NumberFormat format = NumberFormat.getNumberInstance(Locale.ROOT);
    static final int POOL_SIZE = 10;

    @Override
    protected class_5250 provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
        class_2487 conf = context.sourceConfig();
        if (conf.method_10545("Inactive")) {
            return ZERO.method_27661();
        }
        double interval = 20.0 * Math.pow(60.0, conf.method_68083("Interval", 0));
        double rate = (double)conf.method_66563("Rate", 0.0f) * interval;
        if (rate > 0.0) {
            int lastAmount;
            double timeBetweenStacks;
            long previousTime = conf.method_68080("LastReceived", 0L);
            long gameTime = context.blockEntity().method_10997().method_75260();
            int diff = (int)(gameTime - previousTime);
            if (diff > 0 && (double)diff > (timeBetweenStacks = (double)(lastAmount = conf.method_68083("LastReceivedAmount", 0)) / rate) * 2.0) {
                conf.method_10556("Inactive", true);
            }
        }
        if (class_3532.method_20390((double)rate, (double)0.0)) {
            rate = 0.0;
        }
        return class_2561.method_43470((String)this.format.format(rate).replace("\u00a0", " "));
    }

    @Override
    public void itemReceived(DisplayLinkBlockEntity be, int amount) {
        if (((Boolean)be.method_11010().method_61767((class_2769)DisplayLinkBlock.POWERED, (Comparable)Boolean.valueOf(true))).booleanValue()) {
            return;
        }
        class_2487 conf = be.getSourceConfig();
        long gameTime = be.method_10997().method_75260();
        if (!conf.method_10545("LastReceived")) {
            conf.method_10544("LastReceived", gameTime);
            return;
        }
        long previousTime = conf.method_68080("LastReceived", 0L);
        class_2499 rates = conf.method_68569("PrevRates");
        if (rates.size() != 10) {
            rates = new class_2499();
            for (int i = 0; i < 10; ++i) {
                rates.add((Object)class_2494.method_23244((float)-1.0f));
            }
        }
        int poolIndex = conf.method_68083("Index", 0) % 10;
        rates.method_68585(poolIndex, (class_2520)class_2494.method_23244((float)((float)((double)amount / (double)(gameTime - previousTime)))));
        float rate = 0.0f;
        int validIntervals = 0;
        for (int i = 0; i < 10; ++i) {
            float pooledRate = rates.method_68575(i, 0.0f);
            if (!(pooledRate >= 0.0f)) continue;
            rate += pooledRate;
            ++validIntervals;
        }
        conf.method_10551("Rate");
        if (validIntervals > 0) {
            conf.method_10548("Rate", rate /= (float)validIntervals);
        }
        conf.method_10551("Inactive");
        conf.method_10569("LastReceivedAmount", amount);
        conf.method_10544("LastReceived", gameTime);
        conf.method_10569("Index", poolIndex + 1);
        conf.method_10566("PrevRates", (class_2520)rates);
        be.updateGatheredData();
    }

    @Override
    protected String getTranslationKey() {
        return "item_throughput";
    }
}

